// Fear Power 31/7/00

/*
========================================================

power_menu.c

	Menu system similar to the old one using 
	numbers rather than the up down arrows
	because i didnt like moving around while 
	trying to select stuff

========================================================
*/ 

#include "g_local.h"


void Menu_Open (edict_t *ent, entry_t *menu, int size)
{
	menu_t	*m;
	if (developer->value)
		gi.dprintf("DEBUG: void Menu_Open (edict_t *ent, entry_t *menu, int size)\n");

	if (!ent->client || !ent->client->pers.connected)
		return;

//CDEATH MODIFIED
/*	if (ent->client->motd_on)
	{
		// turn off?
		ent->client->motd_on =false;
		//return;
	}
*/	if (ent->client->pers.team == 0)
		return;

	if (ent->client->resp.menu)
	{
		if (developer->value)
			gi.dprintf("warning, ent already has a menu\n");
		Menu_Close(ent);
	}
//CDEATH MODIFIED
	else
	{
		m = malloc(sizeof(menu_t));
		m->size = size;
		m->entries = menu;
		if (developer->value)
			gi.dprintf("DEBUG: Menu memory allocated\n");

//CDEATH MODIFIED
		ent->client->showscores = SCORE_MENU;
		ent->client->resp.inmenu = true;
		ent->client->resp.menu = m;
	}

	Menu_Update(ent);
	gi.unicast (ent, true);
}
void Menu_Close(edict_t *ent)
{
	if (developer->value)
		gi.dprintf("DEBUG: menu close accessed\n");
/*	if (!ent->client->menu)
		return;
*/
//CDEATH MODIFIED
//guarantee we always release any memory allocated
	if(ent->client->resp.menu != NULL)
//	if(ent->client->inmenu == true)
	{
		free(ent->client->resp.menu);
		ent->client->resp.menu = NULL;
		if (developer->value)
			gi.dprintf("DEBUG: menu memory released\n");
	}
//CDEATH MODIFIED
	ent->client->resp.inmenu = false;
	ent->client->showscores = SCORE_OFF;
}

edict_t *find_trader (edict_t *ent);

void Menu_Update (edict_t *ent)
{
	menu_t		*m;
	entry_t		*e;
	char		*t, string[1400];
	int			x =0 , y = 60, i, sel = 0;

	if (developer->value)
		gi.dprintf("DEBUG: void Menu_Update (edict_t *ent)\n");

	if (!ent->client || !ent->client->pers.connected)
		return;

	if (!ent->client->resp.menu) {
		gi.dprintf("warning:  ent has no menu\n");
		return;
	}

	m = ent->client->resp.menu;
	x = 120;// Align left

	strcpy(string, "");

	for (i = 0, e = m->entries; i < m->size; i++, e++, y += 18)
	{
		
		char rgb[] = "999";

		if (!e->text)
			continue; // Blank line

		t = e->text;

		if (*t == '*')
		{
			// Highlighted
			t++;
			if (e->enabled)
				strcpy(rgb, "981");
			else
				strcpy(rgb, "541");
		}
		else
		{
			if (!e->enabled)
				strcpy(rgb, "444");
		}
							
		if (e->align == ALIGN_CENTER)
			x = 640/2 -5*strlen(t);
		else if (e->align == ALIGN_RIGHT)
			x = - 120 + (640 - strlen(t)*10);
		else
			x = 120;

		// Postion
		sprintf(string + strlen(string), " yt %d xl %d dmstr %s \"", //CDEATH MODIFIED
			y, x, rgb);

		sprintf(string + strlen(string), "%s\t\t\"", t);
		
		if (e->cost)
		{
			if (e->enabled)
				strcpy(rgb, "981");
			else
				strcpy(rgb, "541");

			sprintf(string + strlen(string), "yt %d xl 550 dmstr %s \"%d\"", 
				y,  rgb, e->cost);
		}
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}
/*
Menu_Select

*/
void Menu_Select(edict_t *ent, int arg)
{
	menu_t		*m;
//	entry_t		*m;
	entry_t		*e;
	int			i, sel = 0;
	
	if (developer->value)
		gi.dprintf("DEBUG: Menu_Select\n");
	
	if (!ent->client->resp.menu) {
		gi.dprintf("warning:  ent has no menu\n");
		return;
	}
//CDEATH MODIFIED
	if (arg == 10)// Zero (10) reserved for close menu
	{
		Menu_Close(ent);
		return;
	}

	m = ent->client->resp.menu;

	for (i = 0, e = m->entries; i < m->size; i++, e++)
	{
		if (!e->select_func)
			continue;			

		// First character determines selection key
		if (*(e->text) == '0' + arg) 
		{
			if (!e->enabled)
				return;

			if (e->cost) 
			{
				if (ent->client->pers.currentcash >= e->cost) 
				{
					ent->client->pers.currentcash -= e->cost;
					e->select_func (ent, e);
				} 
				else
				{
					gi.cprintf (ent, PRINT_HIGH, "Not enough cash\n");

					// TODO make trader say something
				}
			} 
			else
				e->select_func (ent, e);

			return;
		}
	}
}

int Menu_Get_Key (char *s)
{
	if (Q_stricmp(s, "pipe") == 0)
		return 1;
	else if (Q_stricmp(s, "pistol") == 0)
		return 2;
	else if (Q_stricmp(s, "shotgun") == 0)
		return 3;
	else if (Q_stricmp(s, "tommygun") == 0)
		return 4;
	else if (Q_stricmp(s, "heavy machinegun") == 0)
		return 5;
	else if (Q_stricmp(s, "grenade launcher") == 0)
		return 6;
	else if (Q_stricmp(s, "bazooka") == 0)
		return 7;
	else if (Q_stricmp(s, "flamethrower") == 0)
		return 8;
	else if (Q_stricmp(s, "nine") == 0)
		// weapon 9 & 10 needs a binding
		return 9;
	else if (Q_stricmp(s, "zero") == 0)
		return 10;

	return 0;// Exit
}
